(function($) {
    "use strict";

    var dzSettingsOptions = {};

    function getCookie(name) {
        var cname = encodeURIComponent(name) + "=";
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) === ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(cname) === 0) {
                return decodeURIComponent(c.substring(cname.length, c.length));
            }
        }
        return "";
    }

    var savedTheme = getCookie("version");
    var defaultTheme = "light";

    var currentTheme = savedTheme !== "" ? savedTheme : defaultTheme;

    dzSettingsOptions = {
        typography: "poppins",
        version: currentTheme,
        layout: "vertical",
        primary: "color_1",
        headerBg: "color_4",
        navheaderBg: "color_4",
        sidebarBg: "color_1",
        sidebarStyle: "full",
        sidebarPosition: "fixed",
        headerPosition: "fixed",
        containerLayout: "full",
    };

    new dzSettings(dzSettingsOptions);

    $(document).on('keydown', function(event) {
        if (event.keyCode == 123) {
            event.preventDefault(); 
        }
    });

})(jQuery);
